% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite.R
\name{ukb_gen_write_bgenie}
\alias{ukb_gen_write_bgenie}
\title{Writes a BGENIE format phenotype or covariate file.}
\usage{
ukb_gen_write_bgenie(x, ukb.sample, ukb.variables, path, ukb.id = "eid",
  na.strings = "-999")
}
\arguments{
\item{x}{A UKB dataset.}

\item{ukb.sample}{A UKB sample file.}

\item{ukb.variables}{A character vector of either the phenotypes for a BGENIE phenotype file, or covariates for a BGENIE covariate file.}

\item{path}{A path to a file.}

\item{ukb.id}{The eid variable name (default = "eid").}

\item{na.strings}{Character string to be used for missing value in output file. Default = "-999"}
}
\description{
Writes a space-delimited file with a header, missing character set to "-999", and observations (i.e. UKB subject ids) in sample file order. Use this function to write phenotype and covariate files for downstream genetic analysis in \href{https://jmarchini.org/bgenie/}{BGENIE} - the format is the same.
}
\details{
Uses a \code{dplyr::left_join} to the sample file to match sample file order. Any IDs in the sample file not included in the phenotype or covariate data will be missing for all variables selected. See \href{https://jmarchini.org/bgenie-usage/}{BGENIE usage} for descriptions of the \code{--pheno} and \code{--covar} flags to read phenotype and covariate data into BGENIE.
}
\examples{
\dontrun{

# Automatically sorts observations to match UKB sample file and writes missing values as -999

my_ukb_sample <- ukb_gen_read_sample("ukb.sample")

ukb_gen_write_bgenie(
   my_ukb_data,
   ukb.sample = my_ukb_sample,
   ukb.variables = c("height", "weight", "iq")
   path = "my_ukb_bgenie.pheno",
)

ukb_gen_write_bgenie(
   my_ukb_data,
   ukb.sample = my_ukb_sample,
   ukb.variables = c("age", "socioeconomic_status", "genetic_pcs")
   path = "my_ukb_bgenie.cov",
)
}

}
\seealso{
\code{\link{ukb_gen_read_sample}} to read a sample file, \code{\link{ukb_gen_excl_to_na}} to update a phenotype with NAs for samples to-be-excluded based on genetic metadata, and \code{\link{ukb_gen_write_plink}} to write phenotype and covariate files to PLINK format.
}
