% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arr.R
\name{arr}
\alias{arr}
\alias{print.ufsARR}
\title{Absolute Relative Risk and confidence interval}
\usage{
arr(
  expPos,
  expN,
  conPos,
  conN,
  conf.level = 0.95,
  digits = 2,
  printAsPercentage = TRUE
)

\method{print}{ufsARR}(x, digits = x$digits, printAsPercentage = x$printAsPercentage, ...)
}
\arguments{
\item{expPos}{Number of positive events in the experimental condition.}

\item{expN}{Total number of cases in the experimental condition.}

\item{conPos}{Number of positive events in the control condition.}

\item{conN}{Total number of cases in the control condition.}

\item{conf.level}{The confidence level for the confidence interval.}

\item{digits}{The number of digits to round to when printing the results.}

\item{printAsPercentage}{Whether to multiply with 100 when printing the results.}

\item{x}{The result of the call to \code{arr}.}

\item{...}{Any additional arguments are neglected.}
}
\value{
An object with in \code{estimate}, the ARR, and in \code{conf.int}, the
confidence interval.
}
\description{
This is a function to conveniently and quickly compute
the absolute relative risk (ARR) and its confidence interval.
}
\examples{
ufs::arr(10, 60, 20, 60);
}
