% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authorise.R
\name{uber_oauth}
\alias{uber_oauth}
\title{Authenticate with the Uber API}
\usage{
uber_oauth(client_key, client_secret, cache = TRUE)
}
\arguments{
\item{client_key}{The client key provided by Uber.}

\item{client_secret}{The client secreat provided by Uber.}

\item{cache}{Whether or not to cache authentication token.}
}
\description{
This function wraps the process of OAuth2.0 authentication with the Uber API. This must be done before further interactions can take place.
}
\details{
If \code{cache = TRUE} then the authentication token will be stored in a \code{.httr-oauth} file.
}
\examples{
\dontrun{
# The key/secret combination below is not valid.
uber_oauth("ReTZRlEGNnzkitsn-A23MiXbnMNzdQf8",
           "NpWYGY8W7cv63tfM2neciVpjZOAF_wx1GHRG94A2")
}
}
\seealso{
\code{\link[httr]{oauth_app}}.
}

