% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_digitize.R
\name{digitize}
\alias{digitize}
\title{Easy digitizing of vector features within your rstudio session (or any browser)}
\usage{
digitize(mapCenter = NULL, zoom = 15, line = TRUE,
  rectangle = TRUE, poly = TRUE, circle = TRUE, point = TRUE,
  remove = TRUE, position = "topright",
  maplayer = c("CartoDB.Positron", "OpenStreetMap", "Esri.WorldImagery",
  "Thunderforest.Landscape", "OpenTopoMap"), overlay = NULL,
  features = NULL, preset = "all", locPreset = "muf", cex = 10,
  lwd = 2, alpha = 0.6, opacity = 0.7)
}
\arguments{
\item{mapCenter}{c(lat,lon) central point of the leaflet map}

\item{zoom}{initial zoom level}

\item{line}{enable the draw tool line tool}

\item{rectangle}{enable the draw polygon tool}

\item{poly}{enable the draw polygon tool}

\item{circle}{enable the draw circle tool}

\item{point}{enable the draw point tool}

\item{remove}{enable/disable the remove feature of the draw tool}

\item{position}{place to put the toolbar (topright, topleft, bottomright, bottomleft)}

\item{maplayer}{string. as provided by leaflet-provider}

\item{overlay}{optional sp object}

\item{features}{features}

\item{preset}{character. defaut is "NULL" full draw version, "uav" for flightarea digitizing, "ext" for rectangles}

\item{locPreset}{character. default is "muf" for Marburg University Forest, others are "tra" Traddelstein, "hag" Hagenstein, "baw" Bayerwald.}

\item{cex}{cex}

\item{lwd}{lwd}

\item{alpha}{alpha}

\item{opacity}{opacity}
}
\description{
digitize is based on the leaflet draw plugin. It provides a bunch of leaflet maps as base layers for digitizing vector features.
}
\note{
You can either save the digitized object to a \code{JSON} or \code{KML} file to your hard disk. As an alternative you may grab the \code{JSON} string via the clipboard.
}
\examples{
\dontrun{
##- libs
require(sp)
require(uavRst)

##- preset for digitizing uav flight areas in Meuse
require(sp)
data(meuse) 
sp::coordinates(meuse) <- ~x+y 
sp::proj4string(meuse) <-sp::CRS("+init=epsg:28992") 
me<-sp::spTransform(meuse,CRSobj = sp::CRS("+init=epsg:4326"))
uavRst::digitize(overlay = me)
  
##- preset for digitizing extents
uavRst::digitize(preset="ext",overlay = me)}

}
\author{
Chris Reudenbach
}
