% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typeRun.R
\name{typeRun}
\alias{typeRun}
\title{Type and Run R Code with Live Evaluation}
\usage{
typeRun(
  file,
  delay = 0.05,
  jitter = 0.01,
  max_print = 10,
  envir = new.env(parent = .GlobalEnv)
)
}
\arguments{
\item{file}{Character string. Path to an R script (.R), R Markdown (.Rmd), or
Quarto (.qmd) file to type and execute.}

\item{delay}{Numeric. Base delay in seconds between typing each character.
Default is 0.05 (50 milliseconds).}

\item{jitter}{Numeric. Standard deviation for random variation in typing speed,
adding natural typing rhythm. Default is 0.01.}

\item{max_print}{Integer. Maximum number of elements to print for long outputs
(vectors, data frames, matrices, lists). Default is 10.}

\item{envir}{Environment. The environment in which to evaluate R code.
Default is a new environment with the global environment as parent.}
}
\value{
Invisibly returns \code{NULL}. Called for side effects (typing animation
and code evaluation).
}
\description{
An enhanced version of \code{\link{typeR}} that not only simulates typing but also
evaluates R code in real-time.  Supports interactive pause/resume control and handles
both Quarto/R Markdown documents and plain R scripts.
}
\details{
\code{typeRun()} extends the basic \code{typeR()} functionality by:
\itemize{
\item \strong{Live Code Evaluation: } Executes R code chunks as they are typed
\item \strong{Interactive Control:} Press ESC/Ctrl+C to pause, then choose to resume or stop
\item \strong{Smart Output:} Truncates long outputs and handles models intelligently
\item \strong{Format Support:} Handles .R, .Rmd, and .qmd files intelligently
}

For Quarto/R Markdown files, \code{typeRun()}:
\itemize{
\item Skips YAML headers
\item Only evaluates code in R code chunks
\item Preserves narrative text without evaluation
}

For R scripts, it evaluates all non-comment, non-empty lines.
}
\section{Output Handling}{

\itemize{
\item Assignments and plotting functions execute silently
\item Long vectors/data frames are truncated to \code{max_print} elements
\item Model summaries (lm, glm, etc.) display using R's standard print methods
\item Raw model objects (without summary call) show a simple fitted message
\item Package loading messages (library/require) are suppressed
\item Errors are caught and displayed without stopping execution
}
}

\section{Interactive Control}{

During execution, you can:
\enumerate{
\item Press \strong{ESC} (or Ctrl+C on some systems) to pause
\item Enter \strong{1} to resume from where you paused
\item Enter \strong{2} to stop completely
}
}

\examples{
# Create a temporary R script for demonstration
tmp <- tempfile(fileext = ".R")
writeLines(c(
  "# Simple calculation",
  "x <- 1:5",
  "print(mean(x))",
  "y <- x^2",
  "print(sum(y))"
), tmp)

# Type and run with fast animation (for quick testing)
\donttest{
  typeRun(tmp, delay = 0.01, max_print = 5)
}

# Clean up
unlink(tmp)

# Interactive examples with real files
if (interactive()) {
  # Type and run a simple R script
  typeRun("analysis.R")

  # Type and run with slower, more dramatic effect
  typeRun("demo.R", delay = 0.1, jitter = 0.02)

  # Type and run a Quarto document with limited output
  typeRun("report.qmd", max_print = 5)
}

}
\seealso{
\code{\link{typeR}} for typing without evaluation
}
