% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvma.R
\name{tvma}
\alias{tvma}
\title{Time Varying Mediation Function: Continuous Outcome and Two Treatment Groups}
\usage{
tvma(
  treatment,
  t.seq,
  mediator,
  outcome,
  t.est = t.seq,
  plot = FALSE,
  CI = "boot",
  replicates = 1000,
  verbose = FALSE
)
}
\arguments{
\item{treatment}{a vector indicating treatment group}

\item{t.seq}{a vector of time points for each observation}

\item{mediator}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{t.est}{a vector of time points at which to estimate. 
Default = t.seq (OPTIONAL ARGUMENT)}

\item{plot}{TRUE or FALSE for producing plots. Default = "FALSE" 
(OPTIONAL ARGUMENT)}

\item{CI}{"none" or "boot" method of deriving confidence intervals. 
Default = "boot" (OPTIONAL ARGUMENT)}

\item{replicates}{number of replicates for bootstrapping confidence intervals. 
Default = 1000 (OPTIONAL ARGUMENT)}

\item{verbose}{TRUE or FALSE for printing results to screen. 
Default = "FALSE" (OPTIONAL ARGUMENT)}
}
\value{
\item{hat.alpha}{estimated time-varying treatment effect on mediator}

\item{CI.lower.alpha}{CI lower limit for estimated coefficient hat.alpha}

\item{CI.upper.alpha}{CI upper limit for estimated coefficient hat.alpha}

\item{hat.gamma}{estimated time-varying treatment effect on outcome (direct effect)}

\item{CI.lower.gamma}{CI lower limit for estimated coefficient hat.gamma}

\item{CI.upper.gamma}{CI upper limit for estimated coefficient hat.gamma}

\item{hat.beta}{estimated time-varying effect of the mediator on outcome}

\item{CI.lower.beta}{CI lower limit for estimated coefficient hat.beta}

\item{CI.upper.beta}{CI upper limit for estimated coefficient hat.beta}

\item{hat.tau}{estimated time-varying treatment effect on outcome (total effect)}

\item{CI.lower.tau}{CI lower limit for estimated coefficient hat.tau}

\item{CI.upper.tau}{CI upper limit for estimated coefficient hat.tau}

\item{est.M}{time varying mediation effect}

\item{boot.se.m}{estimated standard error for est.M}

\item{CI.lower}{CI lower limit for est.M}

\item{CI.upper}{CI upper limit for est.M}
}
\description{
Function to estimate the time-varying mediation effect and bootstrap standard 
errors for two treatment groups and a continuous outcome.
}
\note{
\enumerate{
\item{** IMPORTANT ** An alternate way of formatting the data and calling the 
    function is documented in detail in the tutorial for the tvmb() function.}
}
}
\section{Plot Returns}{

\enumerate{
\item{\code{Alpha_CI }}{plot for hat.alpha with CIs over t.est}
\item{\code{Gamma_CI }}{plot for hat.gamma with CIs over t.est}
\item{\code{Beta_CI }}{plot for hat.beta with CIs over t.est}
\item{\code{Tau_CI }}{plot for hat.tau with CIs over t.est}
\item{\code{MedEff }}{plot for est.M over t.est}
\item{\code{MedEff_CI }}{plot for est.M with CIs over t.est}
}
}

\examples{
\dontrun{data(smoker)

# REDUCE DATA SET TO ONLY 2 TREATMENT CONDITIONS (EXCLUDING COMBINATION NRT)
smoker.sub <- smoker[smoker$treatment != 4, ]

# GENERATE WIDE FORMATTED MEDIATORS
mediator <- LongToWide(smoker.sub$SubjectID,
                       smoker.sub$timeseq,
                       smoker.sub$NegMoodLst15min)

# GENERATE WIDE FORMATTED OUTCOMES
outcome <- LongToWide(smoker.sub$SubjectID,
                      smoker.sub$timeseq,
                      smoker.sub$cessFatig)

# GENERATE A BINARY TREATMENT VARIABLE
trt <- as.numeric(unique(smoker.sub[,c("SubjectID","varenicline")])[,2])-1

# GENERATE A VECTOR OF UNIQUE TIME POINTS
t.seq <- sort(unique(smoker.sub$timeseq))

# COMPUTE TIME VARYING MEDIATION ANALYSIS USING BOOTSTRAPPED CONFIDENCE INTERVALS
results <- tvma(trt, t.seq, mediator, outcome)

# COMPUTE TIME VARYING MEDIATION ANALYSIS FOR SPECIFIED POINTS IN TIME USING 250 REPLICATES
results <- tvma(trt, t.seq, mediator, outcome,
                t.est = c(0.2, 0.4, 0.6, 0.8),
                replicates = 250)}
}
\references{
\enumerate{
\item{Fan, J. and Gijbels, I. Local polynomial modelling and its 
      applications: Monographs on statistics and applied probability 66. 
      CRC Press; 1996.}
\item{Fan J, Zhang W. Statistical Estimation in Varying Coefficient Models. 
      The Annals of Statistics. 1999;27(5):1491-1518.}
\item{Fan J, Zhang JT. Two-step estimation of functional linear models with 
      applications to longitudinal data. Journal of the Royal Statistical Society: 
      Series B (Statistical Methodology). 2000;62(2):303-322.}
\item{Cai X, Coffman DL, Piper ME, Li R. Estimation and inference for the mediation 
      effect in a time-varying mediation model. BMC Med Res Methodol. 
      2022;22(1):1-12.}
\item{Baker TB, Piper ME, Stein JH, et al. Effects of Nicotine Patch vs Varenicline 
      vs Combination Nicotine Replacement Therapy on Smoking Cessation at 26 Weeks: 
      A Randomized Clinical Trial. JAMA. 2016;315(4):371.}
\item{B. Efron, R. Tibshirani. Bootstrap Methods for Standard Errors, Confidence 
      Intervals, and Other Measures of Statistical Accuracy. Statistical Science. 
      1986;1(1):54-75.}
}
}
