% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_missing_data.R
\name{model_missing_data}
\alias{model_missing_data}
\title{Model missing time series data}
\usage{
model_missing_data(
  data,
  tau = 0.5,
  S,
  no.of.last.indices.to.fix = S,
  indices.to.fix = NULL,
  lags = c(1, 2, S, S + 1, 7 * S, 7 * S + 1, -1, -2, -S, -S - 1, -7 * S, -7 * S - 1),
  extreg = NULL,
  n.best.extreg = NULL,
  use.data.as.ext = FALSE,
  lag.externals = FALSE,
  consider.as.missing = NULL,
  whole.period.missing.only = FALSE,
  min.val = -Inf,
  max.val = Inf,
  digits = 3,
  ...
)
}
\arguments{
\item{data}{an input vector, matrix or data frame of dimension nobs x nvars
containing missing values; each column is a variable.}

\item{tau}{the quantile(s) of the missing values to be estimated in the
quantile regression. Tau accepts all values in (0,1), the default is 0.5.}

\item{S}{a number of observations per period, e.g. per day.}

\item{no.of.last.indices.to.fix}{a number of observations in the tail of
the data to be fixed, by default set to S.}

\item{indices.to.fix}{indices of the data to be fixed. If NULL, then it is
calculated based on the no.of.last.indices.to.fix parameter. Otherwise, the
no.of.last.indices.to.fix parameter is ignored.}

\item{lags}{a numeric vector with the lags to use in the autoregression.
Negative values are accepted and then also the "future" observations are
used for modelling. The default values are constructed under the assumption
that S describes daily periodicity.}

\item{extreg}{a vector, matrix or data frame of data containing external
regressors; each column is a variable.}

\item{n.best.extreg}{a numeric value specifying the maximal number of considered
best correlated external regressors (selected in decreasing order). If NULL,
then all variables in extreg are used for modelling.}

\item{use.data.as.ext}{logical specifying whether to use the remaining
variables in the data as external regressors or not.}

\item{lag.externals}{logical specifying whether to lag the external
regressors or not. If TRUE, then the algorithm uses the lags specified in
parameter lags.}

\item{consider.as.missing}{a vector of numerical values which are considered
as missing in the data.}

\item{whole.period.missing.only}{if FALSE, then all observations which correspond to
the values of consider.as.missing are treated as missings. If TRUE, then only
consecutive observations of specified length are considered (length is defined by S).}

\item{min.val}{a single value or a vector of length nvars providing the
minimum possible value of each variable in the data. If a single value, then
it applies to all variables. By default set to -Inf.}

\item{max.val}{a single value or a vector of length nvars providing the
maximum possible value of each variable in the data. If a single value, then
it applies to all variables. By default set to Inf.}

\item{digits}{integer indicating the number of decimal places allowed
in the data, by default set to 3.}

\item{...}{additional arguments for the \link[quantreg]{rq.fit.fnb} algorithm.}
}
\value{
An object of class "tsrobprep" which contains the original data, the
indices of the data that were modelled, the given quantile values, a list of
sparse matrices with the modelled data to be imputed and a list of the numbers
of models estimated for every variable.
}
\description{
Returns an object of class "tsrobprep" which contains the original data and
the modelled missing values to be imputed. The function model_missing_data
models missing values in a time series data using the quantile regression
implemented in quantreg package. The model uses autoregression on the time
series as explanatory variables as well as the provided external variables.
The function is designed for numerical data only.
}
\details{
The function uses quantile regression in order to model missing
values and prepare it for imputation. In this purpose the
\link[quantreg]{rq.fit.fnb} function from quantreg package is used. The
function computes the quantile regression methods utilizing the Frisch-Newton
algorithm for user-specified quantile values. The modelled values can be
imputed using \link[tsrobprep]{impute_modelled_data} function.
}
\examples{
model.miss <- model_missing_data(data = GBload[,-1], S = 48, tau = 0.5,
              no.of.last.indices.to.fix = dim(GBload)[1], consider.as.missing = 0,
              min.val = 0)
model.miss$estimated.models
model.miss$replaced.indices
new.GBload <- impute_modelled_data(model.miss)
}
\seealso{
\link[tsrobprep]{impute_modelled_data}, \link[tsrobprep]{handle_outliers},
\link[tsrobprep]{auto_data_cleaning}
}
