% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmonth.R
\name{yearmonth}
\alias{yearmonth}
\alias{is_yearmonth}
\title{Represent year-month}
\usage{
yearmonth(x, ...)

is_yearmonth(x)
}
\arguments{
\item{x}{Other object.}

\item{...}{Further arguments to methods.}
}
\value{
year-month (\code{yearmonth}) objects.
}
\description{
\lifecycle{stable}

Create or coerce using \code{yearmonth()}.
}
\section{Display}{

Use \code{format()} to display \code{yearweek}, \code{yearmonth}, and \code{yearquarter} objects
in required formats.
Please see \code{\link[=strptime]{strptime()}} details for supported conversion specifications.
}

\examples{
# coerce POSIXct/Dates to yearmonth
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 month")
yearmonth(x)

# parse characters
yearmonth(c("2018 Jan", "2018-01", "2018 January"))

# seq() and arithmetic
mth <- yearmonth("2017-11")
seq(mth, length.out = 10, by = 1) # by 1 month
mth + 0:9

# display formats
format(mth, format = "\%y \%m")

# units since 1970 Jan
as.double(yearmonth("1969 Jan") + 0:24)
}
\seealso{
\link{scale_x_yearmonth} and others for ggplot2 scales

Other index functions: 
\code{\link{yearquarter}()},
\code{\link{yearweek}()}
}
\concept{index functions}
