% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{count_gaps}
\alias{count_gaps}
\title{Count implicit gaps}
\usage{
count_gaps(.data, .full = FALSE, .name = c(".from", ".to", ".n"))
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{.full}{\code{FALSE} to find gaps for each series within its own period.
\code{TRUE} to find gaps over the entire time span of the data.}

\item{.name}{Strings to name new columns.}
}
\value{
A tibble contains:
\itemize{
\item the "key" of the \code{tbl_ts}
\item ".from": the starting time point of the gap
\item ".to": the ending time point of the gap
\item ".n": the number of implicit missing observations during the time period
}
}
\description{
Count implicit gaps
}
\examples{
ped_gaps <- pedestrian \%>\%
  count_gaps(.full = TRUE)
ped_gaps
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  stop("Please install the ggplot2 package to run these following examples.")
}
library(ggplot2)
ggplot(ped_gaps, aes(x = Sensor, colour = Sensor)) +
  geom_linerange(aes(ymin = .from, ymax = .to)) +
  geom_point(aes(y = .from)) +
  geom_point(aes(y = .to)) +
  coord_flip() +
  theme(legend.position = "bottom")
}
\seealso{
Other implicit gaps handling: \code{\link{fill_gaps}},
  \code{\link{has_gaps}}, \code{\link{scan_gaps}}
}
\concept{implicit gaps handling}
