% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{slide2}
\alias{slide2}
\alias{slide2_dfr}
\alias{slide2_dfc}
\alias{pslide}
\alias{pslide_dfr}
\alias{pslide_dfc}
\title{Sliding window calculation over multiple inputs simultaneously}
\usage{
slide2(.x, .y, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE)

slide2_dfr(.x, .y, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE, .id = NULL)

slide2_dfc(.x, .y, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE)

pslide(.l, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE)

pslide_dfr(.l, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE, .id = NULL)

pslide_dfc(.l, .f, ..., .size = 1, .fill = NA, .partial = FALSE,
  .align = "right", .bind = FALSE)
}
\arguments{
\item{.x, .y}{Objects to slide over simultaneously.}

\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.fill}{A value to fill at the left of the data range (\code{NA} by default).
\code{NULL} means no filling.}

\item{.partial}{if \code{TRUE}, partial sliding.}

\item{.align}{Align index at the "\strong{r}ight", "\strong{c}entre"/"center", or "\strong{l}eft"
of the window. If \code{.size} is even for center alignment, "centre-right" & "centre-left"
is needed.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}

\item{.l}{A list of lists. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\description{
Rolling window with overlapping observations:
\itemize{
\item \code{slide2()} and \code{pslide()} always returns a list.
\item \code{slide2_lgl()}, \code{slide2_int()}, \code{slide2_dbl()}, \code{slide2_chr()} use the same
arguments as \code{slide2()}, but return vectors of the corresponding type.
\item \code{slide2_dfr()} \code{slide2_dfc()} return data frames using row-binding & column-binding.
}
}
\examples{
x <- 1:5
y <- 6:10
z <- 11:15
lst <- list(x = x, y = y, z = z)
df <- as.data.frame(lst)
slide2(x, y, sum, .size = 2)
slide2(lst, lst, ~ ., .size = 2)
slide2(df, df, ~ ., .size = 2)
pslide(lst, ~ ., .size = 1)
pslide(list(lst, lst), ~ ., .size = 2)

###
# row-wise sliding over data frame
###

my_df <- data.frame(
  group = rep(letters[1:2], each = 8),
  x = c(1:8, 8:1),
  y = 2 * c(1:8, 8:1) + rnorm(16),
  date = rep(as.Date("2016-06-01") + 0:7, 2)
)

slope <- function(...) {
  data <- list(...)
  fm <- lm(y ~ x, data = data)
  coef(fm)[[2]]
}

my_df \%>\% 
  nest(-group) \%>\% 
  mutate(slope = purrr::map(data, ~ pslide_dbl(., slope, .size = 2))) \%>\% 
  unnest()
## window over 2 months
pedestrian \%>\% 
  filter(Sensor == "Southern Cross Station") \%>\% 
  index_by(yrmth = yearmonth(Date_Time)) \%>\% 
  nest(-yrmth) \%>\% 
  mutate(ma = slide_dbl(data, ~ mean(.$Count), .size = 2, .bind = TRUE))
# row-oriented workflow
\dontrun{
my_diag <- function(...) {
  data <- list(...)
  fit <- lm(Count ~ Time, data = data)
  tibble(fitted = fitted(fit), resid = residuals(fit))
}
pedestrian \%>\%
  filter(Date <= as.Date("2015-01-31")) \%>\%
  nest(-Sensor) \%>\%
  mutate(diag = purrr::map(data, ~ pslide_dfr(., my_diag, .size = 48)))
}
}
\seealso{
\itemize{
\item \link{slide}
\item \link{tile2} for tiling window without overlapping observations
\item \link{stretch2} for expanding more observations
}
}
\alias{slide2_lgl}
\alias{slide2_chr}
\alias{slide2_int}
\alias{slide2_dbl}
\alias{pslide_lgl}
\alias{pslide_chr}
\alias{pslide_int}
\alias{pslide_dbl}
