% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{build_tsibble}
\alias{build_tsibble}
\title{Construct a tsibble object}
\usage{
build_tsibble(x, key, index, index2, groups = id(), regular = TRUE,
  validate = TRUE, ordered = NULL, interval = NULL)
}
\arguments{
\item{x}{A \code{data.frame}, \code{tbl_df}, \code{tbl_ts}, or other tabular objects.}

\item{key}{Structural variable(s) that define unique time indices, used with
the helper \link{id}. If a univariate time series (without an explicit key),
simply call \code{id()}. See below for details.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{index2}{A candidate of \code{index} to update the index to a new one when
\link{index_by}. By default, it's identical to \code{index}.}

\item{groups}{Grouping variable(s) when \link{group_by.tbl_ts}.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). \code{TRUE}
finds the greatest common divisor of positive time distances as the interval.}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables lead to unique time indices (i.e. a valid tsibble). It will
also make sure that the nested variables are arranged from lower level to
higher, if nested variables are passed to \code{key}. If you are sure that it's a
valid input, specify \code{FALSE} to skip the checks.}

\item{ordered}{The default of \code{NULL} arranges the key variable(s) first and
then index in ascending order. \code{TRUE} suggests to skip the ordering as \code{x} in
the correct order. \code{FALSE} also skips the ordering but gives a warning instead.}

\item{interval}{\code{NULL} computes the interval. Use the specified interval as
is, if an class of \code{interval} is supplied.}
}
\description{
A relatively more controllable function to create a \code{tbl_ts} object. It is useful
for creating a \code{tbl_ts} internally inside a function, and it allows users to
determine if the time needs ordering and the interval needs calculating.
}
\examples{
# Prepare `pedestrian` to use a new index `Date` ----
pedestrian \%>\%
  build_tsibble(
    key = key(.), index = !! index(.), index2 = Date, interval = interval(.)
  )
}
