% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/avg_coverage.R
\name{avg_coverage_arima}
\alias{avg_coverage_arima}
\title{Compute the average coverage of the prediction intervals computed by
naive plug-in method and \code{\link{arima_pi}}}
\usage{
avg_coverage_arima(phi = NULL, theta = NULL, d = 0, n, n_ahead = 1,
  nsim2, nsim = 100, level = 0.95, prior = "uniform",
  return_all_coverages = FALSE, ...)
}
\arguments{
\item{phi}{vector containing the AR parameters}

\item{theta}{vector containing the MA parameters}

\item{d}{degree of differencing}

\item{n}{length of the time series}

\item{n_ahead}{length of the forecast horizon}

\item{nsim2}{number of simulations used in computing the expected coverage}

\item{nsim}{number of simulations used in importance sampling}

\item{level}{desired coverage probability of the prediction intervals}

\item{prior}{prior to be used in importance sampling. Multiple choices are allowed.}

\item{return_all_coverages}{return raw results i.e. coverages for each simulations. When \code{FALSE} (default), summary statistics are returned.}

\item{...}{additional arguments to \code{\link{arima_pi}}.}
}
\value{
a list containing the coverage probabilities
}
\description{
Computes expected coverage probabilities of the prediction intervals of
ARMA process by simulating time series from the known model.
}
\examples{
\dontrun{
set.seed(123)
# takes a while, notice se, increase nsim2 to get more accurate results
avg_coverage_arima(phi = 0.9, n = 50, n_ahead = 10, nsim2 = 100)

avg_coverage_arima(phi = 0.9, theta = -0.6, n = 50, n_ahead = 10, nsim2 = 100)
}
}
\seealso{
\code{\link{arima_pi}}.
}

