% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_resamp.R
\name{resample_vec}
\alias{resample_vec}
\title{Resampling schemes}
\usage{
resample_vec(
  x,
  boot.scheme = c("resample", "resample_block", "wild1", "wild2", "check"),
  seed = NULL,
  block.size = 2
)
}
\arguments{
\item{x}{A numeric vector}

\item{boot.scheme}{The type of resampling scheme used, see Details}

\item{seed}{the seed used, see \code{\link{set.seed}}}

\item{block.size}{for the \code{resample_block} scheme, the size of the blocks.}
}
\description{
Bootstrap a vector according to multiple resampling schemes: resampling, block resampling, Wild bootstrap.
}
\details{
This function offers various bootstrap/resampling schemes:
\describe{
  \item{resample}{Resampling with replacement}
  \item{resample_block}{Resampling contiguous observations (blocks) with replacement. Use argument \code{block.size}}
  \item{wild1}{Wild bootstrap: do not resample, but add a N(0,1) distribution to each value}
  \item{wild12}{Wild bootstrap: same, but add instead -1 or 1. }
}
}
