\name{VECM.sim}
\alias{TVECM.sim}
\alias{VECM.sim}
\title{Simulation and bootstrap of bivariate VECM/TVECM}
\usage{
  VECM.sim(data, B, VECMobject, beta, n = 200, lag = 1,
    type = c("simul", "boot", "check"),
    include = c("const", "trend", "none", "both"),
    starting = NULL,
    innov = rmnorm(n, mean = 0, varcov = varcov),
    varcov = diag(1, k), show.parMat = FALSE)

  TVECM.sim(data, B, TVECMobject, nthresh = 1, Thresh,
    beta, n = 200, lag = 1,
    type = c("simul", "boot", "check"),
    include = c("const", "trend", "none", "both"),
    starting = NULL,
    innov = rmnorm(n, mean = 0, varcov = varcov),
    varcov = diag(1, k), show.parMat = FALSE)
}
\arguments{
  \item{data}{matrix of parameter to simulate}

  \item{B}{Matrix of coefficients to simulate}

  \item{TVECMobject,VECMobject}{Object computed by function
  \code{\link{TVECM}} or linear \code{\link{VECM}}}

  \item{nthresh}{number of threshold (see details)}

  \item{Thresh}{The threshold value(s). Vector of length
  nthresh}

  \item{beta}{The cointegrating value}

  \item{n}{Number of observations to create when
  type="simul"}

  \item{lag}{Number of lags to include in each regime}

  \item{type}{Whether a bootstrap or simulation is to
  employ. See details}

  \item{include}{Type of deterministic regressors to
  include. NOT WORKING PROPERLY CURRENTLY if not const}

  \item{starting}{Starting values when a simulation with
  given parameter matrix is made}

  \item{innov}{Innovations used for simulation. Should be
  matrix of dim nxk. By default multivariate normal.}

  \item{varcov}{Variance-covariance matrix for the
  innovations. By default multivariate normal is used.}

  \item{show.parMat}{Logical. Should the parameter matrix
  be shown? Useful to understand how to give right input}
}
\value{
  A matrix with the simulated/bootstraped series.
}
\description{
  Estimate or bootstraps a multivariate Threshold VAR
}
\details{
  This function offers the possibility to generate series
  following a VECM/TVECM from two approaches: bootstrap or
  simulation. \code{VECM.sim} is just a wrapper for
  \code{\link{TVECM.sim}}.

  When the argument \code{matrix} is given, on can only
  simulate a VECM (\code{nthresh}=0) or TVECM
  (\code{nthresh}=1 or 2). One can have a specification
  with constant (\code{"const"}), \code{"trend"},
  \code{"both"} or \code{"none"} (see argument
  \code{include}). Order for the parameters is
  ECT/include/lags for VECM and
  ECT1/include1/lags1/ECT2/include2/lags2 for TVECM. To be
  sure that once is using it correctly, setting
  \code{show.parMat = TRUE} will show the matrix of
  parameters together with their values and names.

  The argument \code{beta} is the contegrating value on the
  right side of the long-run relationship, and hence the
  function use the vector (1,-beta). The \code{innov}
  argument specifies the innovations. It should be given as
  a matrix of dim nxk, (here \var{n} does not include the
  starting values!), by default it uses a multivariate
  normal distribution, with covariance matrix specified by
  \code{varcov}.

  The starting values (of dim lags x k) can be given
  through argument \code{starting}. The user should take
  care for their choice, since it is not sure that the
  simulated values will cross the threshold even once.
  Notice that only one cointegrating value is allowed. User
  interested in simulating a VECM with more cointegrating
  values should do use the VAR representation and use
  \code{\link{TVAR.sim}}.

  The second possibility is to bootstrap series. This is
  done on a object generated by \code{\link{TVECM}} (or
  \code{\link{VECM}}). A simple residual bootstrap is done,
  or one can simulate a series with the same parameter
  matrix and with normal distributed residuals (with
  variance pre-specified), corresponding to Monte-carlo
  simulations.

  One can alternatively give only the series, and then the
  function will call internally \code{\link{TVECM}}.
}
\examples{
###reproduce example in Enders (2004, 2 edition) p. 350,
# (similar example in Enders (2010, 3 edition) 301-302).

if(require(mnormt)){
#see that the full "VAR" coefficient matrix is:
 A <- matrix(c(-0.2, 0.2, 0.2, -0.2), byrow=TRUE, ncol=2)

# but this is not the input of VECM.sim. You should decompose into the a and b matrix:
 a<-matrix(c(-0.2, 0.2), ncol=1)
 b<-matrix(c(1,-1), nrow=1)

# so that:
 a\%*\%b

# The a matrix is the input under argument B, while the b matrix is under argument beta:
# (the other zeros in B are for the not-specified lags)
 innov<-rmnorm(100, varcov=diag(2))
 startVal <- matrix(0, nrow=2, ncol=1)
 Bvecm <- rbind(c(-0.2, 0,0), c(0.2, 0,0))
 vecm1 <- VECM.sim(B=Bvecm, beta=1,n=100, lag=1,include="none", innov=innov, starting=startVal)
 ECT <- vecm1[,1]-vecm1[,2]

#add an intercept as in panel B
 Bvecm2 <- rbind(c(-0.2, 0.1,0,0), c(0.2,0.4, 0,0))
 vecm2 <- VECM.sim(B=Bvecm2,  n=100,beta=1, lag=1,include="const", innov=innov, starting=startVal)

 par(mfrow=c(2,1))
 plot(vecm1[,1], type="l", main="Panel a: no drift or intercept", ylab="", xlab="")
 lines(vecm1[,2], lty=2)
 plot(vecm2[,1], type="l", main="Panel b: drift terms (0.1)", ylab="", xlab="")
 lines(vecm2[,2], lty=2)
}
##Bootstrap a TVAR with 1 threshold (two regimes)
data(zeroyld)
dat<-zeroyld
TVECMobject<-TVECM(dat, nthresh=1, lag=1, ngridBeta=20, ngridTh=20, plot=FALSE)
TVECM.sim(TVECMobject=TVECMobject,type="boot")

##Check the bootstrap
TVECM.sim.check <- TVECM.sim(TVECMobject=TVECMobject,type="check")
all(TVECM.sim.check==dat)
}
\author{
  Matthieu Stigler
}
\seealso{
  \code{\link{TVECM}} to estimate a TVECM,
  \code{\link{VAR.sim}} to simulate/bootstrap a VAR.
}
\keyword{ts}

