% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.triptych}
\alias{plot.triptych}
\alias{autoplot.triptych}
\alias{plot.triptych_murphy}
\alias{autoplot.triptych_murphy}
\alias{plot.triptych_reliability}
\alias{autoplot.triptych_reliability}
\alias{plot.triptych_roc}
\alias{autoplot.triptych_roc}
\alias{plot.triptych_mcbdsc}
\alias{autoplot.triptych_mcbdsc}
\title{Plot methods for the triptych classes}
\usage{
\method{plot}{triptych}(x, ...)

\method{autoplot}{triptych}(object, ...)

\method{plot}{triptych_murphy}(x, ...)

\method{autoplot}{triptych_murphy}(object, ...)

\method{plot}{triptych_reliability}(x, ...)

\method{autoplot}{triptych_reliability}(object, ..., breaks = seq(0, 1, length.out = 11))

\method{plot}{triptych_roc}(x, ...)

\method{autoplot}{triptych_roc}(object, ...)

\method{plot}{triptych_mcbdsc}(x, ...)

\method{autoplot}{triptych_mcbdsc}(
  object,
  ...,
  n_isolines = 10,
  colour_values = "black",
  colour_unc = "#00BF7D",
  MCBDSC_repel = FALSE,
  MCB_lim = NA,
  DSC_lim = NA
)
}
\arguments{
\item{x}{An object that inherits from one of the triptych classes.}

\item{...}{Arguments passed from \code{autoplot.triptych()} to the other methods for triptych classes.}

\item{object}{An object that inherits from one of the triptych classes.}

\item{breaks}{A vector of bin boundaries for the \code{geom_histogram()} layer. Set to \code{NA} to disable.}

\item{n_isolines}{The number of isolines showing mean scores.}

\item{colour_values}{A colour specification passed to the \code{values} argument
of \code{scale_colour_manual()}. Recycled if length 1.}

\item{colour_unc}{A colour specification highlighting the UNC component layers.}

\item{MCBDSC_repel}{A boolean value indicating whether labels should be placed
by the \code{ggrepel} package.}

\item{MCB_lim}{The plot limits for the x-axis (the MCB component).}

\item{DSC_lim}{The plot limits for the y-axis (the DSC component).}
}
\value{
For an object of class \code{'triptych'}: A patchwork object (invisibly).

For all other triptych objects: A ggplot object (invisibly).

Every \code{plot()} method wraps the corresponding \code{autoplot()} method,
followed by an explicit \code{print()} call.
That is, it always draws a plot, even during assignment or within a loop.
}
\description{
Plot methods for the triptych classes
}
\examples{
data(ex_binary, package = "triptych")
tr <- triptych(ex_binary)

dplyr::slice(tr, 1, 3, 6, 9) |> autoplot()
autoplot(tr$murphy)
autoplot(tr$reliability)
autoplot(tr$roc)
autoplot(tr$mcbdsc)

}
