% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_track_kml.R
\name{write_track_kml}
\alias{write_track_kml}
\title{Create a time-continuous KML file}
\usage{
write_track_kml(id, lon, lat, utc, z = NULL,
  kml_file = tempfile(fileext = ".kmz"), name = NULL,
  altitude_mode = c("absolute", "clampToGround", "clampToSeaFloor",
  "relativeToGround", "relativeToSeaFloor"))
}
\arguments{
\item{id}{vector of grouping IDs (or a trip object)}

\item{lon}{vector of longitude (ignored if id is a trip)}

\item{lat}{vector of latitude (ignored if id is a trip)}

\item{utc}{vector of POSIXct date-times (ignored if id is a trip)}

\item{z}{vector of elevations, this cannot be set if 'id' is a trip}

\item{kml_file}{filename for KML (KML or KMZ) (must end in .kml or .kmz)}

\item{name}{internal name of dat (derived from kml_file if not specified)}

\item{altitude_mode}{the altitude mode, 'absolute', 'clampToGround', 'clampToSeaFloor',
'relativeToGround', or 'relativeToSeaFloor', see Details}
}
\value{
character vector, file name location of file produced
}
\description{
Export track data to a KML file, for use in Google Earth the continuous
time slider.
}
\details{
To include altitude set every argument explicitly, by input of separate
'id', 'lon', 'lat', 'utc' and 'z' arguments. If the first argument 'id' is
a trip object there is no facility to include the 'z' altitude values.

If 'z' is included it is applied as a third coordinate, with 'altitude_mode'
controlling the interpretation, see
\url{https://developers.google.com/kml/documentation/altitudemode}.
If the 'kml_file' ends with ".kmz" the file is compressed, otherwise it must
end with ".kml" and the compression archive step is not applied.

Sadly the interactive time slider is only available with the desktop version of
Google Earth, the data loads into the browser version but can't be interactive.
}
\examples{
\dontrun{
kfile <- write_track_kml(walrus818[seq(1, 1000, by = 5), ])
print(kfile)
unlink(kfile)
}
}
\author{
Original implementation by Tomislav Hengl in the 'plotKML' package for 'SpatialLinesDataFrame',
adapted by M. Sumner for use in continuous-time form.
}
