% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/grid.R
\name{tripGrid}
\alias{tripGrid}
\title{Generate a grid of time spent by line-to-cell gridding}
\usage{
tripGrid(x, grid = NULL, method = "pixellate", ...)
}
\arguments{
\item{x}{object of class \code{trip}}

\item{grid}{GridTopology - will be generated automatically if NULL}

\item{method}{pixellate or density}

\item{\dots}{pass arguments to density.psp if that method is chosen (and
temporary mechanism to direct users of legacy methods to
\code{\link{tripGrid.interp}})}
}
\value{
\code{tripGrid} returns an object of class \code{SpatialGridDataFrame}, with
one column "z" containing the time spent in each cell in seconds.
}
\description{
Create a grid of time spent from an object of class \code{trip} by exact
cell crossing methods, weighted by the time between locations for separate
trip events.
}
\details{
Zero-length lines cannot be summed directly, their time value is summed by
assuming the line is a point. A warning is given. The density method returns
proportionate values, not summed time durations.

See \code{pixellate.psp} and \code{pixellate.ppp} for the details on the
method used. See \code{density.psp} for method="density".

Trip events are assumed to start and end as per the object passed in. To
work with inferred "cutoff" positions see \code{split.trip.exact}.
}
\keyword{manip}

