% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_solveAlphaXsampleSize.R
\name{solveAlphaXsampleSize}
\alias{solveAlphaXsampleSize}
\title{Sample size calculation}
\usage{
solveAlphaXsampleSize(
  alpha,
  beta0,
  beta1,
  effsz0,
  effsz1,
  szratio = 1,
  t0 = 1,
  t1 = 1,
  tc0 = t0,
  tc1 = t1,
  rho = 0,
  iuse0 = 1,
  iuse1 = 1,
  phi0 = rep(1, length(alpha)),
  phi1 = rep(1, length(alpha)),
  usingRhoForBoundary = FALSE,
  method = "trigger",
  myinit
)
}
\arguments{
\item{alpha}{a number of overall type I error rate}

\item{beta0}{a number of type II error rate for H0}

\item{beta1}{a number of type II error rate for H1}

\item{effsz0}{a number of the effect size of testing H0}

\item{effsz1}{a number of the effect size of testing H1}

\item{szratio}{a number of the ratio of sample size of testing H0 to that of testing H1}

\item{t0}{a vector of information times for H0}

\item{t1}{a vector of information times for H1}

\item{tc0}{a vector of calendar times for H0}

\item{tc1}{a vector of calendar times for H1}

\item{rho}{a value of correlation coefficient between H0 and H1}

\item{iuse0}{an integer shows the type of group sequential boundaries used for the primary endpoint}

\item{iuse1}{an integer shows the type of group sequential boundaries used for the secondary endpoint}

\item{phi0}{a parameter for the power family or the HSD gamma family for the primary endpoint}

\item{phi1}{a parameter for the power family or the HSD gamma family for the secondary endpoint}

\item{usingRhoForBoundary}{an indicator whether using the informaiton of rho to calculate the boundary, default is FALSE (not using)}

\item{method}{a text of method, including \code{trigger}, \code{holm}, \code{maurer-bretz}, \code{bonferroni}}

\item{myinit}{a vector of two starting points for alpha0 and sample size.}
}
\value{
a list of two values, \code{alpha0} and \code{groupsize}
}
\description{
This function computes the sample size and the error rate pre-assigned to the primary endpoint using methods of \code{trigger}, \code{holm}, \code{maurer-bretz}, \code{bonferroni}.
}
\examples{
# Single Stage Example
alpha <- 0.025
effsz0 <- 0.4
effsz1 <- 0.30
szratio <- 1
beta0 <- 0.10
beta1 <- 0.20
solveAlphaXsampleSize(alpha, beta0, beta1, 
    effsz0, effsz1, szratio)
# Multi-stage example
alpha=0.025
beta0=0.10
beta1=0.20
effsz0=0.33
effsz1=0.30
szratio=1
t0=c(0.5,0.9,1)
t1=c(0.6,1)
tc0=c(1,2)
tc1=c(1,2,3)
rho=0
iuse0=1
iuse1=2
phi0=-4
phi1=1
usingRhoForBoundary=FALSE
myinit=c(300,alpha/2)
myinit=c(200,alpha/10)
method="trigger"
method="bonferroni"
method="holm"
method="maurer-bretz"
solveAlphaXsampleSize(alpha=alpha, 
    beta0=beta0, beta1=beta1, 
    effsz0=effsz0, effsz1=effsz1, 
    szratio=szratio, 
    t0=t0, t1=t1, tc0=tc0, tc1=tc1, 
    rho=rho, iuse0=iuse0, iuse1=iuse1, 
    phi0=phi0, phi1=phi1, 
    usingRhoForBoundary=usingRhoForBoundary, 
    method=method, 
    myinit=myinit) 
}
\references{
Gou, J. (2021). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. Technical report.
}
