% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_sPwRholm.R
\name{sPwRholm}
\alias{sPwRholm}
\title{Power of testing the secondary hypothesis using Holm}
\usage{
sPwRholm(
  alpha,
  alpha0,
  t0,
  t1,
  delta0,
  delta1,
  rho = 0,
  iuse0 = 1,
  iuse1 = 1,
  phi0 = rep(1, length(alpha)),
  phi1 = rep(1, length(alpha))
)
}
\arguments{
\item{alpha}{a number shows the overall error rate}

\item{alpha0}{a number shows the error rate assigned to the primary endpoint initially}

\item{t0}{a vector shows the information times of the primary endpoint}

\item{t1}{a vector shows the information times of the secondary endpoint}

\item{delta0}{a value of delta for hypothesis H0}

\item{delta1}{a value of delta for hypothesis H1}

\item{rho}{a number shows the correlation between the primary and secondary endpoints}

\item{iuse0}{an integer shows the type of group sequential boundaries used for the primary endpoint}

\item{iuse1}{an integer shows the type of group sequential boundaries used for the secondary endpoint}

\item{phi0}{a parameter for the power family or the HSD gamma family for the primary endpoint}

\item{phi1}{a parameter for the power family or the HSD gamma family for the secondary endpoint}
}
\value{
a number shows the statistical power of rejecting H1
}
\description{
This function computes the power of testing the secondary hypothesis using Holm
}
\examples{
alpha <-  0.025
alpha0 <- 0.01
iuse0 <- 4
iuse1 <- 4
phi0 <- -4
phi1 <- -4
t0 <- (1:5)/5
t1 <- (1:4)/4
rho <- 0.5
delta0 <- 1
delta1 <- 3
sPwRholm(alpha=alpha, alpha0=alpha0, 
    t0=t0, t1=t1, 
    delta0=delta0, delta1=delta1, 
    rho=rho, iuse0=iuse0, iuse1=iuse1, 
    phi0=phi0, phi1=phi1)
}
