% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen_centrality.R
\name{eigen_centrality}
\alias{eigen_centrality}
\title{Eigen vector centrality}
\usage{
eigen_centrality(phy, weight = TRUE, scale = FALSE, use_rspectra = FALSE)
}
\arguments{
\item{phy}{phylo object or ltable}

\item{weight}{if TRUE, uses branch lengths.}

\item{scale}{if TRUE, the Eigenvector is rescaled}

\item{use_rspectra}{boolean to indicate whether the helping package RSpectra
should be used, which is faster, but returns fewer eigen values.}
}
\value{
List with the Eigen vector and the leading Eigen value
}
\description{
Eigen vector centrality associates with each node \eqn{v}
the positive value \eqn{e(v)}, such that:
\eqn{ \sum_{e}^v w(uv) * e(u) = \lambda * e(v) }. Thus,
\eqn{e(v)} is the Perron-Frobenius eigenvector of the adjacency matrix of the
tree.
}
\references{
Chindelevitch, Leonid, et al. "Network science inspires novel
tree shape statistics." Plos one 16.12 (2021): e0259877.
}
