% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language_field_name_for_id}
\alias{language_field_name_for_id}
\title{Language field names}
\usage{
language_field_name_for_id(x, id)
}
\arguments{
\item{x}{\verb{[tree_sitter_language]}

A tree-sitter language object.}

\item{id}{\verb{[integer]}

The language field identifiers to look up field names for.}
}
\value{
A character vector the same length as \code{id} containing:
\itemize{
\item The field name for the field identifier, if known.
\item \code{NA}, if the field identifier was not known.
}
}
\description{
Get the field name for a field identifier.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
language_field_name_for_id(language, 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=language_field_id_for_name]{language_field_id_for_name()}}
}
