% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distFunctions.R
\name{treeDist}
\alias{treeDist}
\title{Calculates the distance between trees}
\usage{
treeDist(
  x,
  Y,
  type = c("default", "yEvaluated", "tipLabel"),
  method = c("fraction", "logDiff", "wLogDiff", "pa", "ap"),
  y,
  numThreads = -1
)
}
\arguments{
\item{x}{single phylo object}

\item{Y}{a list of phylo objects}

\item{type}{one of:
\describe{
  \item{\dQuote{real}}{tree distinguishing polynomials in two variables x (columns) and y (rows)}
  \item{\dQuote{yEvaluated}}{tree distinguishing polynomials with y evaluated at a specified argument}
  \item{\dQuote{tipLabel}}{complex coefficient polynomial that utilize binary trait tip labels on the phylo objects}
}}

\item{method}{method to use when calculating coefficient distances:
\describe{
  \item{\dQuote{fraction}}{for two coefficient matrices A and B returns sum(abs(A-B)/(A+B)), excluding elements where both A and B are zero}
  \item{\dQuote{logDiff}}{for two coefficient matrices A and B returns sum(log(1+abs(A-B))}
  \item{\dQuote{wLogDiff}}{performs the \dQuote{logDiff} method with weights on the rows}
  \item{\dQuote{pa}}{total pairs where the coefficient is present in one matrix and absent in the other (presence-absence)}
  \item{\dQuote{ap}}{opposite comparison of pa (absence-presence)}
}}

\item{y}{the y value to evaluate the polynomial at when type is \dQuote{yEvaluated}, ignored otherwise}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
vector of distances
}
\description{
Calculates the distance between two trees or a tree and a list of trees.
}
\note{
\itemize{
  \item the substituted y coefficient vector only supports the \dQuote{logDiff} method and the \dQuote{fraction} method
  \item \dQuote{pa} and \dQuote{ap} force symmetry in the output distance matrix
}
}
\examples{

library(treenomial)
library(ape)

# distance between one 10 tip tree and 100 trees with 30 tips

# generate the trees
tenTipTree <- rtree(10)
thirtyTipList <- rmtree(100, 30)

# find the distance
treeDist(tenTipTree, thirtyTipList, numThreads = 0)
}
