% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateTrawl.R
\name{trawl_LM}
\alias{trawl_LM}
\title{Evaluates the long memory trawl function}
\usage{
trawl_LM(x, alpha, H)
}
\arguments{
\item{x}{the argument at which the long memory trawl function will be
evaluated}

\item{alpha}{the parameter \eqn{\alpha} in the long memory trawl}

\item{H}{the parameter \eqn{H} in the long memory trawl}
}
\value{
the long memory trawl function evaluated at x
}
\description{
Evaluates the long memory trawl function
}
\details{
The trawl function is parametrised by the two parameters \eqn{H> 1}
 and \eqn{\alpha > 0} as follows: \deqn{g(x) = (1-x/\alpha)^{-H},  \mbox{ for
 }  x \le 0.}
}
\examples{
#Evaluate the trawl function at x=-2
trawl_LM(-2,0.9,1.5)
#Plot the trawl function
plot(trawl_LM(-(0:10),0.9,1.5))
}
