% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_Exptrawl}
\alias{fit_Exptrawl}
\title{Fits an exponential trawl function to equidistant time series data}
\usage{
fit_Exptrawl(x, Delta = 1, plotacf = FALSE, lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
lambda: the memory parameter \eqn{\lambda} in the exponential trawl

LM: the Lebesgue measure of the trawl set associated with the
 exponential trawl,  i.e. \eqn{1/\lambda}.
}
\description{
Fits an exponential trawl function to equidistant time series data
}
\details{
The trawl function is parametrised by the parameter \eqn{\lambda > 0}
 as follows: \deqn{g(x) = e^{\lambda x},  \mbox{ for }  x \le 0.} The
 Lebesgue measure of the corresponding trawl set is given by \eqn{1/\lambda}.
}
\examples{
\donttest{
#Simulate a univariate trawl process and fit the exponential trawl function
set.seed(1)
t <- 1000
Delta <- 1
v <- 250
lambda <- 0.25
#Simulate a univariate trawl process with exponential trawl function and
#Poisson marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("Poi"),trawl
="Exp",v=v, lambda1=lambda)
#Fit the exponential trawl function to the simulated data
fittrawlfct <- fit_Exptrawl(trawl,Delta, plotacf=TRUE,lags=500)
#Print the results
print(paste("lambda: estimated:", fittrawlfct$lambda, ", theoretical:",
lambda))
}
}
