% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d8flowdir.R
\name{taudem_d8flowdir}
\alias{taudem_d8flowdir}
\title{D8 Flow Directions}
\usage{
taudem_d8flowdir(
  input_elevation_grid,
  output_d8flowdir_grid = NULL,
  output_d8slopes_grid = NULL,
  n_processes = getOption("traudem.n_processes", 1),
  quiet = getOption("traudem.quiet", FALSE)
)
}
\arguments{
\item{input_elevation_grid}{Pit filled elevation input data.}

\item{output_d8flowdir_grid}{D8 flow directions output.}

\item{output_d8slopes_grid}{D8 slopes output.}

\item{n_processes}{Number of processes for \code{mpiexec}. If \code{NULL} TauDEM is called without mpiexec.}

\item{quiet}{If \code{FALSE} output from TauDEM CLI is suppressed.}
}
\value{
List with the two output filenames.
}
\description{
D8 Flow Directions
}
\details{
See \url{https://hydrology.usu.edu/taudem/taudem5/help53/D8FlowDirections.html}
}
\examples{
\dontshow{if (interactive() && traudem::can_register_taudem()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
test_dir <- withr::local_tempdir()
dir.create(test_dir)
 file.copy(
   system.file("test-data", "DEM.tif", package = "traudem"),
   file.path(test_dir, "DEM.tif")
 )
filled_pit <- taudem_pitremove(file.path(test_dir, "DEM.tif"))
outputs <- taudem_d8flowdir(filled_pit)
outputs
\dontshow{\}) # examplesIf}
}
