% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\name{constant}
\alias{constant}
\title{Internal Constants}
\usage{
constant(which = "")
}
\arguments{
\item{which}{A non-empty and non-\link[base:NA]{NA} character string. The name
of the constant to fetch. See below for defined values.}
}
\value{
\code{\link[=constant]{constant()}} returns the requested constant, or \code{NULL} if it is unavailable.\tabular{lll}{
   \code{which} \tab \strong{Shape} \tab \strong{Value} \cr
   \code{algorithms} \tab \code{character(2)} \tab \code{c("sha1", "utf8")} \cr
   \code{concat} \tab \code{character(1)} \tab \code{" "} \cr
   \code{empty} \tab \code{character(1)} \tab \code{"<empty>"} \cr
   \code{empty-list} \tab \code{character(1)} \tab \code{"<empty list>"} \cr
   \code{null} \tab \code{character(1)} \tab \code{"<null>"} \cr
   \code{unset} \tab \code{character(1)} \tab \code{"<unset>"} \cr
   \code{unknown} \tab \code{character(1)} \tab \code{"<unknown>"} \cr
   \code{untranslated} \tab \code{character(1)} \tab \code{"# Insert a translation here."} \cr
   \code{range-sprintf} \tab \code{character(1)} \tab \code{"Ln \%s, Col \%s @ Ln \%s, Col \%s"} \cr
   \code{range-format} \tab \code{character(1)} \tab \code{"Ln <int>, Col <int> @ Ln <int>, Col <int>"} \cr
   \code{range-pattern} \tab \code{character(1)} \tab \code{"^Ln[ \\t]*([0-9.]+),[ \\t]*Col[ \\t]*..."} \cr
}
}
\description{
Fetch a constant used by \code{\link{transltr}}. Constants ensure
consistency among all features of the package.
}
\section{Algorithms returned by \code{constant("algorithms")}}{

These algorithms map a character string to another character string of
hexadecimal characters highly likely to be unique. The latter is typically
much shorter and is used to uniquely identify a source text (and the
underlying source language). Two algorithms are available.
\subsection{Secure Hash Algorithm 1}{

Method \code{sha1} corresponds to SHA-1 (Secure Hash Algorithm version 1), a
cryptographic hashing function. While it is now superseded by more secure
variants (SHA-256, SHA-512, etc.), it is still useful for non-sensitive
purposes. It is fast, collision-resistant, and may handle very large inputs.
It emits strings of 40 hexadecimal characters.
}

\subsection{Cumulative UTF-8 Sum}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\strong{This method is experimental. Use with caution.}

Method \code{utf8} is a simple method derived from cumulative sums of UTF-8 code
points (converted to integers). It is slightly faster than method \code{sha1} for
small inputs and emits hashes with a width porportional to the underlying
input's length. It is used for testing purposes internally.
}
}

\keyword{internal}
