% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{residuals.LmME}
\alias{residuals.LmME}
\title{Residuals of a LmME model}
\usage{
\method{residuals}{LmME}(object, as.lm = FALSE, ...)
}
\arguments{
\item{object}{An \code{LmME} object.}

\item{as.lm}{If \code{TRUE}, return the residuals as in a normal linear
mixed effects model.}

\item{...}{Optional arguments (currently ignored).}
}
\description{
Calculates the score residuals of an intercept term fixed at 0.
In the case of an LmME model, this is equal to the residual of an LMM.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
resid(fit)
}
