% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranef.tramME}
\alias{ranef.tramME}
\alias{ranef}
\title{Extract the conditional modes and conditional variances of random effects}
\usage{
\method{ranef}{tramME}(object, condVar = FALSE, raw = FALSE, ...)
}
\arguments{
\item{object}{A fitted tramME object.}

\item{condVar}{If TRUE, include the conditional variances as attributes.}

\item{raw}{Return the unformatted RE estimates as fitted by the model.}

\item{...}{Optional arguments (for consistency with generic)}
}
\value{
Depending on the value of raw, either a numeric vector or a
  \code{ranef.tramME} object which contains the conditional mode and variance
  estimates by grouping factors.
}
\description{
Extract the conditional modes and conditional variances of random effects
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy, order = 5)
ranef(fit, raw = TRUE)
ranef(fit)
}
