% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed.R
\name{plot.TrajSpeedIntervals}
\alias{plot.TrajSpeedIntervals}
\title{Plot method for trajectory speed intervals}
\usage{
\method{plot}{TrajSpeedIntervals}(
  x,
  slowerThanColour = "red",
  fasterThanColour = "green",
  highlightColor = "#0000FF1E",
  xlab = sprintf("Time (\%s)", TrajGetTimeUnits(attr(x, "trajectory"))),
  ylab = sprintf("Speed (\%s/\%s)", TrajGetUnits(attr(x, "trajectory")),
    TrajGetTimeUnits(attr(x, "trajectory"))),
  type = "l",
  ...
)
}
\arguments{
\item{x}{An object of class "SpeedIntervals", as created by
\code{\link{TrajSpeedIntervals}}.}

\item{slowerThanColour, fasterThanColour}{The colour of the horizontal line
plotted at the "slower than" or "faster than" speed. Specify \code{NULL} to
prevent the line from being plotted.}

\item{highlightColor}{Colour of the highlight rectangles.}

\item{xlab, ylab, type}{Plotting parameters with useful defaults.}

\item{...}{Additional arguments are passed to \code{\link[graphics]{plot}}.}
}
\description{
Plots speed over time, with intervals of fast and/or slow speed highlighted.
}
\examples{
# Display speed intervals with custom x-axis labels

# Generate and smooth a trajectory
set.seed(3)
trj <- TrajSmoothSG(TrajGenerate(120, fps = 0.5))
# Get speed intervals to be plotted
si <- TrajSpeedIntervals(trj, slowerThan = 0.9, diff = "central")
# Plot, but don't label x axis
plot(si, xlab = "Time (min:sec)", xaxt = "n")
# Work out where x-axis tick marks should be
speeds <- attr(si, "speed") # data frame containing speed over time
p <- pretty(speeds$time)
# Draw x-sxis ticks and labels with custom formatting
axis(1, p, sprintf("\%d:\%02d", p \%/\% 60, p \%\% 60))

}
\seealso{
\code{\link{TrajSpeedIntervals}}
}
