% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{TrajMerge}
\alias{TrajMerge}
\title{Combine multiple trajectories into a single whole trajectory}
\usage{
TrajMerge(parts)
}
\arguments{
\item{parts}{A list containing one or more trajectories. The trajectories are
concatenated together in order.}
}
\value{
A single trajectory.
}
\description{
This is the inverse of \code{\link{TrajSplit}}.
}
\examples{
trj <- TrajGenerate(n = 20)
ntrj <- TrajMerge(TrajSplit(trj, c(3, 9, 20)))
print(all(trj == ntrj))
## [1] TRUE

}
\seealso{
\code{\link{TrajSplit}}
}
