% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitbank.R
\name{traitbank}
\alias{traitbank}
\title{Search for traits from EOL's Traitbank.}
\usage{
traitbank(pageid, cache_ttl = NULL, ...)
}
\arguments{
\item{pageid}{A page id. I know, not ideal. Would be better if this was a trait
id or trait name. This is the page ID for a taxon, not a trait. Apparently, traits
don't have pages. Note: this parameter used to be \code{trait}, but badly
mis-represented what the input actually represents.}

\item{cache_ttl}{Cache code}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Search for traits from EOL's Traitbank.
}
\details{
See http://eol.org/data_glossary for human readable definitions for
the attribute terms that EOL uses. Go to http://eol.org/data_search for the
web interface to Traitbank.
}
\examples{
\dontrun{
# Get data for Balaenoptera musculus (http://eol.org/pages/328574/)
res <- traitbank(328574)
res$context
names( res$graph )
head( res$graph )

# Get data for Closterocerus formosus (http://eol.org/pages/846827/)
traitbank(846827)
}
}
\references{
http://eol.org/info/516
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
