% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birdlife.R
\name{birdlife_habitat}
\alias{birdlife_habitat}
\title{Get bird habitat information from BirdLife/IUCN}
\usage{
birdlife_habitat(id)
}
\arguments{
\item{id}{A single IUCN species ID}
}
\value{
a \code{data.frame} with level 1 and level 2 habitat classes, as
well as importance ratings and occurrence type (e.g. breeding or
non-breeding). The habitat classification scheme is described
at \url{http://bit.ly/1e6gKBr}
}
\description{
Get bird habitat information from BirdLife/IUCN
}
\examples{
\dontrun{
# Setophaga chrysoparia
birdlife_habitat(22721692)
# Passer domesticus
birdlife_habitat(103818789)
}
}
\seealso{
Other birdlife: \code{\link{birdlife_threats}}
}
\author{
David J. Harris \email{harry491@gmail.com}
}
