% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/is_native.R
\name{is_native}
\alias{is_native}
\title{Check if a species is native somewhere}
\usage{
is_native(sp, where, region = c("america", "europe"), ...)
}
\arguments{
\item{sp}{character; a vector of length one with a single scientific species
names in the form of \code{c("Genus species")}.}

\item{where}{character; a vector of length one with a single place. For America has to
match one of those: "Continental US", "Alaska", "Canada", "Caribbean Territories",
"Central Pacific Territories", "Hawaii", "Mexico". For Europe has to match one of
those: "Albania", "Austria", "Azores", "Belgium", "Islas_Baleares", "Britain",
"Bulgaria", "Corse", "Kriti", "Czechoslovakia", "Denmark", "Faroer", "Finland",
"France", "Germany", "Greece", "Ireland", "Switzerland", "Netherlands", "Spain",
"Hungary", "Iceland", "Italy", "Jugoslavia", "Portugal", "Norway", "Poland", "Romania",
"USSR", "Sardegna", "Svalbard", "Sicilia", "Sweden", "Turkey", "USSR_Northern_Division",
"USSR_Baltic_Division", "USSR_Central_Division", "USSR_South_western", "USSR_Krym",
"USSRSouth_eastern_Division"}

\item{region}{character; a vector of length one with a single region. Only "europe"
and "america" implemented "europe" checks Flora Europaea and only contain plants.
"america" checks ITIS and contain both plant and animals.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A vectors saying if is native or exotic. When species is not found in the
database its indicated.
}
\description{
This function check the status (native or exotic) of a species in a
given place

For that end, calls itis_native{taxize} and fe_native{traits}. See help
documentation of those functions for details.

So many more things can be done, like checking species first with taxize, adding
more native lists to check...
}
\examples{
\donttest{
sp <- c("Lavandula stoechas", "Carpobrotus edulis", "Rhododendron ponticum",
       "Alkanna lutea", "Anchusa arvensis")
is_native(sp[1], where = "Islas_Baleares", region = "europe")
sapply(sp, is_native, where = "Continental US", region = "america")
sapply(sp, is_native, where = "Islas_Baleares", region = "europe")
}
}
\author{
Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}
}

