% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{numerical.predictive.power}
\alias{numerical.predictive.power}
\title{numerical.predictive.power}
\usage{
numerical.predictive.power(
  data,
  predict.variable,
  variable.to.compare,
  ylab = "",
  xlab = "",
  main = paste("Variable Density", variable.to.compare, "according to",
    predict.variable),
  col = NA
)
}
\arguments{
\item{data}{A data frame.}

\item{predict.variable}{Character type. The name of the variable to predict. This name must be part of the columns of the data frame.}

\item{variable.to.compare}{Character type. The name of the numeric variable to compare. This name must be part of the columns of the data frame.}

\item{ylab}{A character string that describes the y-axis on the graph.}

\item{xlab}{A character string that describes the x-axis on the graph.}

\item{main}{Character type. The main title of the chart.}

\item{col}{A vector that specifies the colors of the categories of the variable to predict.}
}
\value{
A ggplot object.
}
\description{
Function that graphs the density of individuals and shows their category according to a numerical variable.
}
\note{
With this function we can analyze the predictive power of a numerical variable.
}
\examples{

numerical.predictive.power(iris,"Species","Sepal.Length")

}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
