% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{indexList}
\alias{indexList}
\title{Extract one or more elements from a list}
\usage{
indexList(list, index = NULL)
}
\arguments{
\item{list}{A list-like object, with a \code{[[} indexing method.}

\item{index}{A vector of integers or strings, or \code{NULL}.}
}
\value{
If \code{index} is \code{NULL}, the whole list is returned.
  Otherwise, if \code{index} has length one, the corresponding element is
  extracted and returned. Otherwise a list containing the requested subset
  is returned.
}
\description{
Given a list-like first argument, this function extracts one or more of its
elements. Numeric and character indexing are allowed.
}
\note{
This function is not type-safe, in the sense that its return type
  depends on its arguments. It should therefore be used with care.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{https://www.jstatsoft.org/v44/i08/}.
}
\author{
Jon Clayden
}
