% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trackr-main-API.R, R/recordFile.R
\name{record}
\alias{record}
\alias{rmRecord}
\alias{findRecords}
\alias{recordFiles}
\title{Primary high-level API functions for Trackr Databases}
\usage{
record(object, db = defaultTDB(), resultURI = "",
  code = histry::histry_tracker(), force = FALSE, verbose = FALSE,
  symorpos = NULL, dryrun = FALSE)

rmRecord(object, db = defaultTDB(), verbose = FALSE)

findRecords(pattern, db = defaultTDB(), fields = NULL,
  ret_type = c("doclist", "id", "backend"), verbose = FALSE)

recordFiles(object, ingestfun = NULL, db = defaultTDB(), resultURI = "",
  code = histry_tracker(), force = FALSE, verbose = FALSE,
  symorpos = NULL, dryrun = FALSE)
}
\arguments{
\item{object}{ANY. An object to record. Or (for recordFiles) a
vector of one or more files to record or the path of a single
directory whose contents will be recorded. Or (for rmPlot) the
unique ID of an object in the database to remove.}

\item{db}{TrackrDB. The database}

\item{resultURI}{A URI which can be used to define a
grouping/hierarchy of results recorded via trackr. Currently
unused by trackr itself except as additional metadata to search
across. Defaults to an empty string.}

\item{code}{ANY. Code/evaluation history to be associated with
\code{object}}

\item{force}{logical. Overwrite any existing entry matching
\code{object}.  (default: FALSE)}

\item{verbose}{logical. Should extra informative messages be
displayed ( default: FALSE)}

\item{symorpos}{The symbol or position corresponding to
\code{object} in \code{code}. For normal usage this will not be
required.}

\item{dryrun}{logical. Should a "dry run" be performed. If true,
the \code{insert_record} and \code{trackr_write} steps of the
record process are \emph{not} run, and the result of
\code{prep_for_backend} is immediately returned.}

\item{pattern}{character. A regular expression to match against the text in \code{fields}}

\item{fields}{character or NULL. The fiends in which to match, or NULL to
include all fields.}

\item{ret_type}{character. Format in which to return the response. Options are:
"id" - id of matching documents (default), "list" - A list containing the
matching documents represnted as R lists, and "backend" - a backend specific
representation of the set of matching documents}

\item{ingestfun}{function or NULL. A function which must accept
only the paths argument which will take \code{object} and
return an R object to be recorded and linked to the raw files
indicated by \code{object}}
}
\description{
These functions define the high-level, user-facing
    trackr API.
}
\details{
These functions allow end-users to interact with trackr
    databases. Each function does what its name suggests.

When more than one file is passed to
    \code{recordFiles},either via a vector of paths or the path to
    a directory, the files will be zipped up into a single file
    which will be recorded.
}
\examples{
prevtdb = defaultTDB()
defaultTDB(listTDB())
mt = datasets::mtcars
record(mt)

res = findRecords("mtcars")
stopifnot(length(res) ==1)
rmRecord(mt)

res = findRecords("mtcars")
stopifnot(length(res) == 0)

\dontrun{
f = function(paths) readLines(paths)
fil = system.file("test_docs", "knitr_test.Rmd", package = "trackr")
recordFiles(fil, ingestfun = f)

res= findRecords("test_docs")
}
defaultTDB(prevtdb)
}
