% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentrationProfile.R
\name{concentrationProfile}
\alias{concentrationProfile}
\title{Generate training concentration profiles.}
\usage{
concentrationProfile(object, session = NULL, what = c("speed",
  "heart.rate"), ...)
}
\arguments{
\item{object}{An object of class \code{distrProfile} as returned by \code{\link{distributionProfile}}.}

\item{session}{A numeric vector of the sessions to be used, defaults to all sessions.}

\item{what}{The variables for which the concentration profiles should be generated.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{conProfile}.
}
\description{
Generate training concentration profiles.
}
\examples{
data("run", package = "trackeR")
dProfile <- distributionProfile(run, what = "speed", grid = seq(0, 12.5, by = 0.05))
cProfile <- concentrationProfile(dProfile)
plot(cProfile, smooth = FALSE)
plot(cProfile)
}
\references{
Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
    Endurance Runners to Training and Physiological Effects via Multi-Resolution
    Elastic Net. \emph{ArXiv e-print} arXiv:1506.01388.
}

