% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{duplicated_data}
\alias{duplicated_data}
\title{Find Duplicated Data in a Track Table}
\usage{
duplicated_data(x, type = "txy")
}
\arguments{
\item{x}{\code{\link{track}} table as produced by the \code{\link{track}}
function.}

\item{type}{A character string or a vector of character strings indicating
the type of duplications to look for. The strings can be any combination
of \code{"t"} (for time duplications) and \code{"x"}, \code{"y"}, \code{"z"}
(for coordinate duplications). For instance, the string \code{"txy"} will
return data with duplicated time stamps and duplicated x and y coordinates.}
}
\value{
A track table of all observations that are duplicated, as per the
 duplication rule defined by \code{type}.
}
\description{
This function attempts to automatically detect duplicated
 data in \code{\link{track}} tables.
}
\note{
Incomplete data (that is, data containing "NAs") are ignored.
}
\examples{
# Create data set with duplicated data
data(short_tracks)
t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
              id = short_tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df <- bind_tracks(t_df, t_df[1:10, ], t_df[100:110, ])

# Find duplicated timestamps
duplicated <- duplicated_data(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
