% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interesting-indices.r
\name{norm_bin}
\alias{norm_bin}
\alias{norm_kol}
\title{Normality index.}
\usage{
norm_bin(nr)

norm_kol(nr)
}
\arguments{
\item{nr}{The number of rows in the target matrix}
}
\description{
Compares the similarity between the projected distribution and a normal distribution.
\itemize{
\item norm_bin: compares the count in 100 histogram bins
\item norm_kol: compares the cdf based on the Kolmogorov–Smirnov test (KS test)
}
}
\examples{
# manually compute the norm_kol index
# create the index function
set.seed(123)
index <- norm_kol(nrow(flea[, 1:3]))
# create the projection
proj <- matrix(c(1, 0, 0), nrow = 3)
# pre-process the example data
flea_s <- sphere_data(flea[, 1:3])
# produce the index value
index(flea_s \%*\% proj)
}
\keyword{hplot}
