% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.r
\name{render_gif}
\alias{render_gif}
\title{Render frames of animation to a gif file}
\usage{
render_gif(
  data,
  tour_path,
  display,
  gif_file = "animation.gif",
  ...,
  apf = 1/10,
  frames = 50,
  rescale = TRUE,
  sphere = FALSE,
  start = NULL
)
}
\arguments{
\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator}

\item{display}{the method used to render the projected data,
e.g. \code{\link{display_xy}}, \code{\link{display_pcp}}}

\item{gif_file}{Name of gif file (default = "animation.gif")}

\item{...}{other options passed to \code{\link{png}}}

\item{apf}{angle (in radians) per frame}

\item{frames}{number of frames in output}

\item{rescale}{if true, rescale all variables to range [0,1]}

\item{sphere}{if true, sphere all variables}

\item{start}{starting projection.  If \code{NULL}, uses path default.}
}
\description{
Render frames of animation to a gif file
}
\examples{
\dontrun{
# gifski needs to be installed to render a gif
if (requireNamespace("gifski", quietly = TRUE)) {
  gif_file <- file.path(tempdir(), "test.gif")
  render_gif(flea[, 1:6], grand_tour(), display_xy(), gif_file)
  utils::browseURL(gif_file)
  unlink(gif_file)
}
}
}
