% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{cat2}
\alias{cat2}
\title{Concatenate and Print}
\usage{
cat2(
  ...,
  sep = " ",
  end = "\\n",
  file = "",
  append = FALSE,
  fill = FALSE,
  labels = NULL
)
}
\arguments{
\item{...}{objects passed on to \link[base]{cat}}

\item{sep}{a character vector of strings to append after each element}

\item{end}{a string to print after all other elements}

\item{file}{passed on to \code{\link[base:cat]{base::cat()}}}

\item{append}{passed on to \code{\link[base:cat]{base::cat()}}}

\item{fill}{passed on to \code{\link[base:cat]{base::cat()}}}

\item{labels}{passed on to \code{\link[base:cat]{base::cat()}}}
}
\value{
No return value, called for side effects
}
\description{
Same as \code{cat} but with an additional argument \code{end},
which gets printed after all other elements. Inspired by pythons \code{print}
command.
}
\examples{
x <- 1
cat("x:", x, "\n") # prints 'Number: 1 \n' (with a space between 1 and \n)
cat2("x:", x) # prints 'Number: 1\n'  (without space)
}
\keyword{base}
