% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-cifar.R
\name{cifar10_dataset}
\alias{cifar10_dataset}
\alias{cifar100_dataset}
\title{CIFAR datasets}
\usage{
cifar10_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

cifar100_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{(string): Root directory of dataset where directory
\code{cifar-10-batches-bin} exists or will be saved to if download is set to TRUE.}

\item{train}{Logical. If TRUE, use the training set; otherwise, use the test set. Not applicable to all datasets.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch::dataset object. Each item is a list with:
\itemize{
\item \code{x}: a 32x32x3 integer array
\item \code{y}: the class label
}
}
\description{
The CIFAR datasets are benchmark \strong{classification} datasets composed of
60,000 RGB thumbnail images of size 32x32 pixels. The
\href{https://www.cs.toronto.edu/~kriz/cifar.html}{CIFAR10} variant contains
10 classes while CIFAR100 provides 100 classes. Images are split into
50,000 training samples and 10,000 test samples.

Downloads and prepares the
\href{https://www.cs.toronto.edu/~kriz/cifar.html}{CIFAR100} dataset.
}
\details{
Downloads and prepares the CIFAR archives.
}
\examples{
\dontrun{
ds <- cifar10_dataset(root = tempdir(), download = TRUE)
item <- ds[1]
item$x
item$y
}
}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{eurosat_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{tiny_imagenet_dataset}()}
}
\concept{classification_dataset}
