% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-conv.R
\name{nnf_conv_transpose1d}
\alias{nnf_conv_transpose1d}
\title{Conv_transpose1d}
\usage{
nnf_conv_transpose1d(
  input,
  weight,
  bias = NULL,
  stride = 1,
  padding = 0,
  output_padding = 0,
  groups = 1,
  dilation = 1
)
}
\arguments{
\item{input}{input tensor of shape (minibatch, in_channels , iW)}

\item{weight}{filters of shape (out_channels, in_channels/groups , kW)}

\item{bias}{optional bias of shape (out_channels). Default: \code{NULL}}

\item{stride}{the stride of the convolving kernel. Can be a single number or
a one-element tuple \verb{(sW,)}. Default: 1}

\item{padding}{implicit paddings on both sides of the input. Can be a
single number or a one-element tuple \verb{(padW,)}. Default: 0}

\item{output_padding}{padding applied to the output}

\item{groups}{split input into groups, \code{in_channels} should be divisible by
the number of groups. Default: 1}

\item{dilation}{the spacing between kernel elements. Can be a single number or
a one-element tuple \verb{(dW,)}. Default: 1}
}
\description{
Applies a 1D transposed convolution operator over an input signal
composed of several input planes, sometimes also called "deconvolution".
}
