% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-batchnorm.R
\name{nn_batch_norm1d}
\alias{nn_batch_norm1d}
\title{BatchNorm1D module}
\usage{
nn_batch_norm1d(
  num_features,
  eps = 1e-05,
  momentum = 0.1,
  affine = TRUE,
  track_running_stats = TRUE
)
}
\arguments{
\item{num_features}{\eqn{C} from an expected input of size
\eqn{(N, C, L)} or \eqn{L} from input of size \eqn{(N, L)}}

\item{eps}{a value added to the denominator for numerical stability.
Default: 1e-5}

\item{momentum}{the value used for the running_mean and running_var
computation. Can be set to \code{NULL} for cumulative moving average
(i.e. simple average). Default: 0.1}

\item{affine}{a boolean value that when set to \code{TRUE}, this module has
learnable affine parameters. Default: \code{TRUE}}

\item{track_running_stats}{a boolean value that when set to \code{TRUE}, this
module tracks the running mean and variance, and when set to \code{FALSE},
this module does not track such statistics and always uses batch
statistics in both training and eval modes. Default: \code{TRUE}}
}
\description{
Applies Batch Normalization over a 2D or 3D input (a mini-batch of 1D
inputs with optional additional channel dimension) as described in the paper
\href{https://arxiv.org/abs/1502.03167}{Batch Normalization: Accelerating Deep Network Training by Reducing Internal Covariate Shift}
}
\details{
\deqn{
y = \frac{x - \mathrm{E}[x]}{\sqrt{\mathrm{Var}[x] + \epsilon}} * \gamma + \beta
}

The mean and standard-deviation are calculated per-dimension over
the mini-batches and \eqn{\gamma} and \eqn{\beta} are learnable parameter vectors
of size \code{C} (where \code{C} is the input size). By default, the elements of \eqn{\gamma}
are set to 1 and the elements of \eqn{\beta} are set to 0.

Also by default, during training this layer keeps running estimates of its
computed mean and variance, which are then used for normalization during
evaluation. The running estimates are kept with a default :attr:\code{momentum}
of 0.1.
If \code{track_running_stats} is set to \code{FALSE}, this layer then does not
keep running estimates, and batch statistics are instead used during
evaluation time as well.
}
\section{Note}{


This \code{momentum} argument is different from one used in optimizer
classes and the conventional notion of momentum. Mathematically, the
update rule for running statistics here is
\eqn{\hat{x}_{\mbox{new}} = (1 - \mbox{momentum}) \times \hat{x} + \mbox{momentum} \times x_t},
where \eqn{\hat{x}} is the estimated statistic and \eqn{x_t} is the
new observed value.

Because the Batch Normalization is done over the \code{C} dimension, computing statistics
on \verb{(N, L)} slices, it's common terminology to call this Temporal Batch Normalization.
}

\section{Shape}{

\itemize{
\item Input: \eqn{(N, C)} or \eqn{(N, C, L)}
\item Output: \eqn{(N, C)} or \eqn{(N, C, L)} (same shape as input)
}
}

\examples{
if (torch_is_installed()) {
# With Learnable Parameters
m <- nn_batch_norm1d(100)
# Without Learnable Parameters
m <- nn_batch_norm1d(100, affine = FALSE)
input <- torch_randn(20, 100)
output <- m(input) 

}
}
