% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_eigvalsh}
\alias{linalg_eigvalsh}
\title{Computes the eigenvalues of a complex Hermitian or real symmetric matrix.}
\usage{
linalg_eigvalsh(A, UPLO = "L")
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions
consisting of symmetric or Hermitian matrices.}

\item{UPLO}{('L', 'U', optional): controls whether to use the upper or lower triangular part
of \code{A} in the computations. Default: \code{'L'}.}
}
\value{
A real-valued tensor cointaining the eigenvalues even when \code{A} is complex.
The eigenvalues are returned in ascending order.
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
the \strong{eigenvalues} of a complex Hermitian or real symmetric  matrix \teqn{A \in \mathbb{K}^{n \times n}}
are defined as the roots (counted with multiplicity) of the polynomial \code{p} of degree \code{n} given by
}
\details{
\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
p(\\\\lambda) = \\\\operatorname{det}(A - \\\\lambda \\\\mathrm{I}_n)\\\\mathrlap{\\\\qquad \\\\lambda \\\\in \\\\mathbb{R}}
")}

where \teqn{\mathrm{I}_n} is the \code{n}-dimensional identity matrix.

The eigenvalues of a real symmetric or complex Hermitian matrix are always real.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
The eigenvalues are returned in ascending order.

\code{A} is assumed to be Hermitian (resp. symmetric), but this is not checked internally, instead:
\itemize{
\item If \code{UPLO}\ \verb{= 'L'} (default), only the lower triangular part of the matrix is used in the computation.
\item If \code{UPLO}\ \verb{= 'U'}, only the upper triangular part of the matrix is used.
}
}
\examples{
if (torch_is_installed()) {
a <- torch_randn(2, 2)
linalg_eigvalsh(a)
}
}
\seealso{
\itemize{
\item \code{\link[=linalg_eigh]{linalg_eigh()}} computes the full eigenvalue decomposition.
}

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
