% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{haustest}
\alias{haustest}
\title{Hausman test}
\usage{
haustest(x, y, omit = NULL)
}
\arguments{
\item{x}{the first model,}

\item{y}{the second model}

\item{omit}{a character containing the effects that are removed from the test}
}
\value{
a list with class \code{'htest'} containing the following components:
\itemize{
\item data.mane: a character string describing the fitted model
\item statistic: the value of the test statistic
\item parameter: degrees of freedom
\item p.value: the p.value of the test
\item method: a character indicating what type of test is performed
\item alternative: a character indicating the alternative hypothesis
}
}
\description{
Hausman test
}
\examples{
charitable <- dplyr::mutate(charitable,
                            logdon = log(donation) - log(25))
char_form <- logdon ~ log(donparents) + log(income) +
    education + religion + married + south
ml <- tobit1(char_form, data = charitable)
scls <- update(ml, method = "trimmed")
haustest(scls, ml, omit = "(Intercept)")
}
\references{
\insertRef{HAUS:78}{tobit1}
}
\author{
Yves Croissant
}
\keyword{htest}
