% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-proxy.R
\name{datagrid_proxy}
\alias{datagrid_proxy}
\title{Proxy for datagrid htmlwidget}
\usage{
datagrid_proxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{shinyId}{single-element character vector indicating the output ID of the
chart to modify (if invoked from a Shiny module, the namespace will be added
automatically).}

\item{session}{the Shiny session object to which the chart belongs; usually the
default value will suffice.}
}
\value{
A \code{datagrid_proxy} object.
}
\description{
Proxy for datagrid htmlwidget
}
\examples{
\dontrun{

# Consider having created a datagrid widget with
datagridOutput("my_grid") # UI
output$my_grid <- renderDatagrid({}) # Server

# Then you can call proxy methods in observer:

# set datagrid proxy then call a cal_proxy_* function
datagrid_proxy("my_grid") \%>\%
  datagrid_proxy_addrow(mydata)

# or directly
datagrid_proxy_addrow("my_grid", mydata)

}
}
\seealso{
Other datagrid proxy methods: 
\code{\link{grid_proxy_add_row}()},
\code{\link{grid_proxy_delete_row}()}
}
\concept{datagrid proxy methods}
