% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHeatmap.R
\name{computeHeatmap}
\alias{computeHeatmap}
\title{Compute 2-dimensional multi-layered matrix for heat map visualizations.}
\usage{
computeHeatmap(channel, tableName, dimension1, dimension2,
  aggregates = "COUNT(*) cnt", aggregateFun = NULL, aggregateAlias = NULL,
  dimAsFactor = TRUE, withMelt = FALSE, where = NULL, by = NULL,
  test = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}}

\item{tableName}{table name}

\item{dimension1}{name of the column for for heatmap x values. This value along with \code{dimension2}
are x and y scales of heatmap table.}

\item{dimension2}{name of the column for for heatmap y values. This value along with \code{dimension1}
are x and y scales of heatmap table.}

\item{aggregates}{vector with SQL aggregates to compute values for heat map. Aggregate may have optional 
aliases like in \code{"AVG(era) avg_era"}. Subsequently, use in \code{createHeatmap} as color 
(fill), text, and threshold values for heat map cells.}

\item{aggregateFun}{deprecated. Use \code{aggregates} instead.}

\item{aggregateAlias}{deprecated. Use \code{aggregates} instead.}

\item{dimAsFactor}{logical indicates if dimensions and optional facet columns should be converted to factors.
This is almost always necessary for heat maps.}

\item{withMelt}{logical if TRUE then uses \pkg{reshape2} \code{\link{melt}} to transform data frame
with aggregate values in designated columns into a molten data frame.}

\item{where}{specifies criteria to satisfy by the table rows before applying
computation. The creteria are expressed in the form of SQL predicates (inside
\code{WHERE} clause).}

\item{by}{for optional grouping by one or more values for faceting or alike}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}
}
\value{
Data frame representing 2-dimensional multi-layered matrix to use 
  with \code{\link{createHeatmap}}. Matrix has as many layers as there are 
  aggregates computed. If \code{by} defined, data frame contains multiple 
  matrices for each value(s) from the column(s) in \code{by} (to support facets). 
  When \code{withMelt TRUE} function \code{\link{melt}} applies transforming data frame
  and columns with aggregate values for easy casting: expands number of rows and 
  replaces all aggregate columns with two: \code{variable} and \code{value}.
}
\description{
Compute aggregate value(s) across two category classes represented by the 
table columns \code{dimension1} and \code{dimension2}. Resulting data frame
represents 2-dimensional multi-layered matrix where each layer comprises
values from single aggregate. Category columns usually are of character, 
temporal, or discrete types. Values are aggregates computed across 
category columns utilizing SQL \code{GROUP BY <dimension1>, <dimension2>}. 
Aggregate formula may use any SQL expressions allowed with the \code{GROUP BY}
as defined above. Results are usually fed into \code{\link{createHeatmap}} 
for heat map visualizations. If defined, parameter \code{by} expands 
grouping columns to be used with heat maps with faceting.
 
Result represents 2-dimensional matrix with as many data layers as there were 
aggregates computed. Additionally more layers defined with parameter \code{by} 
support facets.
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")

hm = computeHeatmap(conn, "teams_enh", 'franchid', 'decadeid', 'avg(w) w', 
                    where="decadeid >= 1950")
hm$decadeid = factor(hm$decadeid)
createHeatmap(hm, 'decadeid', 'franchid', 'w')

# with diverging color gradient
hm = computeHeatmap(conn, "teams_enh", 'franchid', 'decadeid', 'avg(w-l) wl', 
                    where="decadeid >= 1950")
hm$decadeid = factor(hm$decadeid)
createHeatmap(hm, 'decadeid', 'franchid', 'wl', divergingColourGradient = TRUE)
}
}
\seealso{
\code{\link{createHeatmap}}
}

