% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player_recruiting_rankings.R
\name{player_recruiting_rankings}
\alias{player_recruiting_rankings}
\title{Get Recruiting Rankings}
\usage{
player_recruiting_rankings(
  year = NULL,
  stars = NULL,
  state = NULL,
  conf = NULL,
  team = NULL,
  top = NULL,
  pos = NULL
)
}
\arguments{
\item{year}{Freshman season for class (class year + 1)}

\item{stars}{247Sports Composite stars}

\item{state}{State abbreviation of recruit; `domestic` or `international`
also taken}

\item{conf}{Conference of school committed to}

\item{team}{Team player committed to}

\item{top}{Top x in 247Sports Composite national rankings}

\item{pos}{247Sports player position to filter for}
}
\value{
Returns a tibble with 31 columns: \describe{
  \item{\code{position}}{character.} \item{\code{player}}{character.}
  \item{\code{height}}{character.} \item{\code{weight}}{double.}
  \item{\code{team}}{character.} \item{\code{conf}}{character.}
  \item{\code{high_school}}{character.} \item{\code{town}}{character.}
  \item{\code{state}}{character.} \item{\code{tfs_comp_rating}}{double.}
  \item{\code{tfs_comp_star}}{integer.} \item{\code{tfs_comp_national}}{double.}
  \item{\code{tfs_comp_position}}{double.} \item{\code{tfs_comp_state}}{double.}
  \item{\code{tfs_rating}}{double.} \item{\code{tfs_star}}{integer.}
  \item{\code{espn_rating}}{double.} \item{\code{espn_grade}}{double.}
  \item{\code{espn_rank}}{double.} \item{\code{rivals_rating}}{double.}
  \item{\code{rivals_rank}}{double.} \item{\code{avg_rank}}{logical.}
  \item{\code{num_offers}}{integer,} \item{\code{announce_date}}{character.}
  \item{\code{tfs_cb}}{character.} \item{\code{tfs_cb_odds}}{double.}
  \item{\code{tfs_cb_alt}}{character.} \item{\code{tfs_cb_alt_odds}}{double.}
  \item{\code{tfs_pid}}{integer.} \item{\code{year}}{integer.}
  \item{\code{id}}{integer.}}
}
\description{
Returns player rankings for major recruiting services
}
\details{
Function pulls high school meta data and recruiting rankings for individual
players from 247Sports, ESPN, and Rivals back to 2008
}
\examples{
player_recruiting_rankings(year=2019, stars=5, state='domestic')

}
