% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_pregame.R
\name{bart_pregame}
\alias{bart_pregame}
\title{Get Pregame Probabilities}
\usage{
bart_pregame(year = current_season(), team = NULL, type = NULL, game_id = NULL)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{team}{Team to filter for.}

\item{type}{Game type to filter for ('nc', 'conf', 'conf_t', 'post', 'nond1')}

\item{game_id}{Game ID to filter for.}
}
\value{
Returns a tibble with 13 columns: \describe{
  \item{\code{date}}{double.} \item{\code{conf}}{character.}
  \item{\code{line}}{character.} \item{\code{ttq}}{double. Torvik Thrill
  Quotient -- measures how good the teams are, how close the game is
  projected to be, and how fast the tempo is projected to be.}
  \item{\code{type}}{character. See details.} \item{\code{team1}}{character.}
  \item{\code{team1_wp}}{double. Estimated win percentage.}
  \item{\code{team1_pts}}{double. Estimated total points.}
  \item{\code{team2}}{character.} \item{\code{team2_wp}}{double. Estimated
  win percentage.} \item{\code{team2_pts}}{double. Estimated total points.}
  \item{\code{game_id}}{character.} \item{\code{year}}{double.} }
}
\description{
Returns pregame win probabilities, expected scores, and thrill quotients for
all games.
}
\details{
Under the `type` column, games are classified by one of five indicators,
explained below: \describe{ \item{nc}{Non-conference games between two D-1
teams.} \item{conf}{In-conference games.} \item{conf_t}{Conference tournament
games.} \item{post}{Post-conference tournament games.} \item{nond1}{Games
involving one non-D1 team.} }
}
\examples{
bart_pregame(year=2022)

}
